/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.tab.csv;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import org.apache.commons.csv.CSVFormat;

public class CsvSettings {
    private static char separatorChar;
    private static String recordSeparator;
    private static Character quoteChar;

    public static Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public static DecimalFormat getNumberFormat() {
        char decimalSeparator = '.';
        DecimalFormat numFormat = new DecimalFormat("#.#");
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        symbols.setDecimalSeparator(decimalSeparator);
        numFormat.setDecimalFormatSymbols(symbols);
        numFormat.setMaximumFractionDigits(4);
        return numFormat;
    }

    public static DateFormat getDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    static CSVFormat getCsvFormat() {
        return CSVFormat.newFormat(separatorChar).withRecordSeparator(recordSeparator).withQuote(quoteChar);
    }

    public static void switchToDllSettings() {
        separatorChar = (char)124;
        recordSeparator = "\r\n";
        quoteChar = null;
    }

    public static void switchToStdSettings() {
        separatorChar = (char)44;
        recordSeparator = "\n";
        quoteChar = Character.valueOf('\"');
    }

    static {
        CsvSettings.switchToStdSettings();
    }
}

